package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum FeatureType implements Enum {

    @JsonProperty("registration")
    REGISTRATION("registration", "0"),

    @JsonProperty("reset")
    RESET("reset", "1"),

    @JsonProperty("unknownFutureValue")
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "2");

    private final String name;
    private final String value;

    private FeatureType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
