package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum ExternalAuthenticationType implements Enum {

    @JsonProperty("passthru")
    PASSTHRU("passthru", "0"),

    @JsonProperty("aadPreAuthentication")
    AAD_PRE_AUTHENTICATION("aadPreAuthentication", "1");

    private final String name;
    private final String value;

    private ExternalAuthenticationType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
