package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum EntityType implements Enum {

    @JsonProperty("event")
    EVENT("event", "0"),

    @JsonProperty("message")
    MESSAGE("message", "1"),

    @JsonProperty("driveItem")
    DRIVE_ITEM("driveItem", "2"),

    @JsonProperty("externalFile")
    EXTERNAL_FILE("externalFile", "3"),

    @JsonProperty("externalItem")
    EXTERNAL_ITEM("externalItem", "4");

    private final String name;
    private final String value;

    private EntityType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
