package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum EnrollmentAvailabilityOptions implements Enum {

    @JsonProperty("availableWithPrompts")
    AVAILABLE_WITH_PROMPTS("availableWithPrompts", "0"),

    @JsonProperty("availableWithoutPrompts")
    AVAILABLE_WITHOUT_PROMPTS("availableWithoutPrompts", "1"),

    @JsonProperty("unavailable")
    UNAVAILABLE("unavailable", "2");

    private final String name;
    private final String value;

    private EnrollmentAvailabilityOptions(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
