package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum EncryptionState implements Enum {

    @JsonProperty("notEncrypted")
    NOT_ENCRYPTED("notEncrypted", "0"),

    @JsonProperty("encrypted")
    ENCRYPTED("encrypted", "1");

    private final String name;
    private final String value;

    private EncryptionState(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
