package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum EmbeddedSIMDeviceStateValue implements Enum {

    @JsonProperty("notEvaluated")
    NOT_EVALUATED("notEvaluated", "0"),

    @JsonProperty("failed")
    FAILED("failed", "1"),

    @JsonProperty("installing")
    INSTALLING("installing", "2"),

    @JsonProperty("installed")
    INSTALLED("installed", "3"),

    @JsonProperty("deleting")
    DELETING("deleting", "4"),

    @JsonProperty("error")
    ERROR("error", "5"),

    @JsonProperty("deleted")
    DELETED("deleted", "6"),

    @JsonProperty("removedByUser")
    REMOVED_BY_USER("removedByUser", "7");

    private final String name;
    private final String value;

    private EmbeddedSIMDeviceStateValue(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
