package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum EmailSyncSchedule implements Enum {

    @JsonProperty("userDefined")
    USER_DEFINED("userDefined", "0"),

    @JsonProperty("asMessagesArrive")
    AS_MESSAGES_ARRIVE("asMessagesArrive", "1"),

    @JsonProperty("manual")
    MANUAL("manual", "2"),

    @JsonProperty("fifteenMinutes")
    FIFTEEN_MINUTES("fifteenMinutes", "3"),

    @JsonProperty("thirtyMinutes")
    THIRTY_MINUTES("thirtyMinutes", "4"),

    @JsonProperty("sixtyMinutes")
    SIXTY_MINUTES("sixtyMinutes", "5"),

    @JsonProperty("basedOnMyUsage")
    BASED_ON_MY_USAGE("basedOnMyUsage", "6");

    private final String name;
    private final String value;

    private EmailSyncSchedule(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
