package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum EducationSynchronizationProfileState implements Enum {

    @JsonProperty("deleting")
    DELETING("deleting", "2"),

    @JsonProperty("deletionFailed")
    DELETION_FAILED("deletionFailed", "3"),

    @JsonProperty("provisioningFailed")
    PROVISIONING_FAILED("provisioningFailed", "5"),

    @JsonProperty("provisioned")
    PROVISIONED("provisioned", "6"),

    @JsonProperty("provisioning")
    PROVISIONING("provisioning", "7"),

    @JsonProperty("unknownFutureValue")
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "8");

    private final String name;
    private final String value;

    private EducationSynchronizationProfileState(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
