package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum EdgeTelemetryMode implements Enum {

    @JsonProperty("notConfigured")
    NOT_CONFIGURED("notConfigured", "0"),

    @JsonProperty("intranet")
    INTRANET("intranet", "1"),

    @JsonProperty("internet")
    INTERNET("internet", "2"),

    @JsonProperty("intranetAndInternet")
    INTRANET_AND_INTERNET("intranetAndInternet", "3");

    private final String name;
    private final String value;

    private EdgeTelemetryMode(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
