package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum EdgeOpenOptions implements Enum {

    @JsonProperty("notConfigured")
    NOT_CONFIGURED("notConfigured", "0"),

    @JsonProperty("startPage")
    START_PAGE("startPage", "1"),

    @JsonProperty("newTabPage")
    NEW_TAB_PAGE("newTabPage", "2"),

    @JsonProperty("previousPages")
    PREVIOUS_PAGES("previousPages", "3"),

    @JsonProperty("specificPages")
    SPECIFIC_PAGES("specificPages", "4");

    private final String name;
    private final String value;

    private EdgeOpenOptions(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
