package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum EasServices implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("calendars")
    CALENDARS("calendars", "1"),

    @JsonProperty("contacts")
    CONTACTS("contacts", "2"),

    @JsonProperty("email")
    EMAIL("email", "4"),

    @JsonProperty("notes")
    NOTES("notes", "8"),

    @JsonProperty("reminders")
    REMINDERS("reminders", "16");

    private final String name;
    private final String value;

    private EasServices(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
