package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum EasAuthenticationMethod implements Enum {

    @JsonProperty("usernameAndPassword")
    USERNAME_AND_PASSWORD("usernameAndPassword", "0"),

    @JsonProperty("certificate")
    CERTIFICATE("certificate", "1"),

    @JsonProperty("derivedCredential")
    DERIVED_CREDENTIAL("derivedCredential", "2");

    private final String name;
    private final String value;

    private EasAuthenticationMethod(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
