package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum EapType implements Enum {

    @JsonProperty("eapTls")
    EAP_TLS("eapTls", "13"),

    @JsonProperty("leap")
    LEAP("leap", "17"),

    @JsonProperty("eapSim")
    EAP_SIM("eapSim", "18"),

    @JsonProperty("eapTtls")
    EAP_TTLS("eapTtls", "21"),

    @JsonProperty("peap")
    PEAP("peap", "25"),

    @JsonProperty("eapFast")
    EAP_FAST("eapFast", "43");

    private final String name;
    private final String value;

    private EapType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
