package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum DomainNameSource implements Enum {

    @JsonProperty("fullDomainName")
    FULL_DOMAIN_NAME("fullDomainName", "0"),

    @JsonProperty("netBiosDomainName")
    NET_BIOS_DOMAIN_NAME("netBiosDomainName", "1");

    private final String name;
    private final String value;

    private DomainNameSource(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
