package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum DmaGuardDeviceEnumerationPolicyType implements Enum {

    @JsonProperty("deviceDefault")
    DEVICE_DEFAULT("deviceDefault", "0"),

    @JsonProperty("blockAll")
    BLOCK_ALL("blockAll", "1"),

    @JsonProperty("allowAll")
    ALLOW_ALL("allowAll", "2");

    private final String name;
    private final String value;

    private DmaGuardDeviceEnumerationPolicyType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
