package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum DlpAction implements Enum {

    @JsonProperty("notifyUser")
    NOTIFY_USER("notifyUser", "0"),

    @JsonProperty("blockAccess")
    BLOCK_ACCESS("blockAccess", "1"),

    @JsonProperty("deviceRestriction")
    DEVICE_RESTRICTION("deviceRestriction", "2");

    private final String name;
    private final String value;

    private DlpAction(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
