package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum DirectoryDefinitionDiscoverabilities implements Enum {

    @JsonProperty("None")
    NONE("None", "0"),

    @JsonProperty("AttributeNames")
    ATTRIBUTE_NAMES("AttributeNames", "1"),

    @JsonProperty("AttributeDataTypes")
    ATTRIBUTE_DATA_TYPES("AttributeDataTypes", "2"),

    @JsonProperty("AttributeReadOnly")
    ATTRIBUTE_READ_ONLY("AttributeReadOnly", "4"),

    @JsonProperty("ReferenceAttributes")
    REFERENCE_ATTRIBUTES("ReferenceAttributes", "8"),

    @JsonProperty("UnknownFutureValue")
    UNKNOWN_FUTURE_VALUE("UnknownFutureValue", "16");

    private final String name;
    private final String value;

    private DirectoryDefinitionDiscoverabilities(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
