package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum DiamondModel implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("adversary")
    ADVERSARY("adversary", "1"),

    @JsonProperty("capability")
    CAPABILITY("capability", "2"),

    @JsonProperty("infrastructure")
    INFRASTRUCTURE("infrastructure", "3"),

    @JsonProperty("victim")
    VICTIM("victim", "4"),

    @JsonProperty("unknownFutureValue")
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "127");

    private final String name;
    private final String value;

    private DiamondModel(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
