package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum DeviceManagementTemplateType implements Enum {

    @JsonProperty("securityBaseline")
    SECURITY_BASELINE("securityBaseline", "0"),

    @JsonProperty("specializedDevices")
    SPECIALIZED_DEVICES("specializedDevices", "1"),

    @JsonProperty("advancedThreatProtectionSecurityBaseline")
    ADVANCED_THREAT_PROTECTION_SECURITY_BASELINE("advancedThreatProtectionSecurityBaseline", "2"),

    @JsonProperty("deviceConfiguration")
    DEVICE_CONFIGURATION("deviceConfiguration", "3"),

    @JsonProperty("custom")
    CUSTOM("custom", "4"),

    @JsonProperty("securityTemplate")
    SECURITY_TEMPLATE("securityTemplate", "5"),

    @JsonProperty("microsoftEdgeSecurityBaseline")
    MICROSOFT_EDGE_SECURITY_BASELINE("microsoftEdgeSecurityBaseline", "6"),

    @JsonProperty("microsoftOffice365ProPlusSecurityBaseline")
    MICROSOFT_OFFICE365PRO_PLUS_SECURITY_BASELINE("microsoftOffice365ProPlusSecurityBaseline", "7"),

    @JsonProperty("deviceCompliance")
    DEVICE_COMPLIANCE("deviceCompliance", "8"),

    @JsonProperty("deviceConfigurationForOffice365")
    DEVICE_CONFIGURATION_FOR_OFFICE365("deviceConfigurationForOffice365", "9");

    private final String name;
    private final String value;

    private DeviceManagementTemplateType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
