package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum DeviceManagementSubscriptions implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("intune")
    INTUNE("intune", "1"),

    @JsonProperty("office365")
    OFFICE365("office365", "2"),

    @JsonProperty("intunePremium")
    INTUNE_PREMIUM("intunePremium", "4"),

    @JsonProperty("intune_EDU")
    INTUNE_EDU("intune_EDU", "8"),

    @JsonProperty("intune_SMB")
    INTUNE_SMB("intune_SMB", "16");

    private final String name;
    private final String value;

    private DeviceManagementSubscriptions(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
