package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum DeviceManagementScheduledReportRecurrence implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("daily")
    DAILY("daily", "1"),

    @JsonProperty("weekly")
    WEEKLY("weekly", "2"),

    @JsonProperty("monthly")
    MONTHLY("monthly", "3");

    private final String name;
    private final String value;

    private DeviceManagementScheduledReportRecurrence(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
