package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum DeviceManagementPartnerAppType implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("singleTenantApp")
    SINGLE_TENANT_APP("singleTenantApp", "1"),

    @JsonProperty("multiTenantApp")
    MULTI_TENANT_APP("multiTenantApp", "2");

    private final String name;
    private final String value;

    private DeviceManagementPartnerAppType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
