package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum DeviceManagementExchangeConnectorType implements Enum {

    @JsonProperty("onPremises")
    ON_PREMISES("onPremises", "0"),

    @JsonProperty("hosted")
    HOSTED("hosted", "1"),

    @JsonProperty("serviceToService")
    SERVICE_TO_SERVICE("serviceToService", "2"),

    @JsonProperty("dedicated")
    DEDICATED("dedicated", "3");

    private final String name;
    private final String value;

    private DeviceManagementExchangeConnectorType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
