package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum DeviceManagementExchangeAccessStateReason implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("unknown")
    UNKNOWN("unknown", "1"),

    @JsonProperty("exchangeGlobalRule")
    EXCHANGE_GLOBAL_RULE("exchangeGlobalRule", "2"),

    @JsonProperty("exchangeIndividualRule")
    EXCHANGE_INDIVIDUAL_RULE("exchangeIndividualRule", "3"),

    @JsonProperty("exchangeDeviceRule")
    EXCHANGE_DEVICE_RULE("exchangeDeviceRule", "4"),

    @JsonProperty("exchangeUpgrade")
    EXCHANGE_UPGRADE("exchangeUpgrade", "5"),

    @JsonProperty("exchangeMailboxPolicy")
    EXCHANGE_MAILBOX_POLICY("exchangeMailboxPolicy", "6"),

    @JsonProperty("other")
    OTHER("other", "7"),

    @JsonProperty("compliant")
    COMPLIANT("compliant", "8"),

    @JsonProperty("notCompliant")
    NOT_COMPLIANT("notCompliant", "9"),

    @JsonProperty("notEnrolled")
    NOT_ENROLLED("notEnrolled", "10"),

    @JsonProperty("unknownLocation")
    UNKNOWN_LOCATION("unknownLocation", "12"),

    @JsonProperty("mfaRequired")
    MFA_REQUIRED("mfaRequired", "13"),

    @JsonProperty("azureADBlockDueToAccessPolicy")
    AZURE_ADBLOCK_DUE_TO_ACCESS_POLICY("azureADBlockDueToAccessPolicy", "14"),

    @JsonProperty("compromisedPassword")
    COMPROMISED_PASSWORD("compromisedPassword", "15"),

    @JsonProperty("deviceNotKnownWithManagedApp")
    DEVICE_NOT_KNOWN_WITH_MANAGED_APP("deviceNotKnownWithManagedApp", "16");

    private final String name;
    private final String value;

    private DeviceManagementExchangeAccessStateReason(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
