package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum DeviceManagementExchangeAccessState implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("unknown")
    UNKNOWN("unknown", "1"),

    @JsonProperty("allowed")
    ALLOWED("allowed", "2"),

    @JsonProperty("blocked")
    BLOCKED("blocked", "3"),

    @JsonProperty("quarantined")
    QUARANTINED("quarantined", "4");

    private final String name;
    private final String value;

    private DeviceManagementExchangeAccessState(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
