package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum DeviceManagementExchangeAccessRuleType implements Enum {

    @JsonProperty("family")
    FAMILY("family", "0"),

    @JsonProperty("model")
    MODEL("model", "1");

    private final String name;
    private final String value;

    private DeviceManagementExchangeAccessRuleType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
