package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum DeviceManagementExchangeAccessLevel implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("allow")
    ALLOW("allow", "1"),

    @JsonProperty("block")
    BLOCK("block", "2"),

    @JsonProperty("quarantine")
    QUARANTINE("quarantine", "3");

    private final String name;
    private final String value;

    private DeviceManagementExchangeAccessLevel(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
