package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum DeviceManagementDomainJoinConnectorState implements Enum {

    @JsonProperty("active")
    ACTIVE("active", "0"),

    @JsonProperty("error")
    ERROR("error", "1"),

    @JsonProperty("inactive")
    INACTIVE("inactive", "2");

    private final String name;
    private final String value;

    private DeviceManagementDomainJoinConnectorState(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
