package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum DeviceManagementComparisonResult implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("equal")
    EQUAL("equal", "1"),

    @JsonProperty("notEqual")
    NOT_EQUAL("notEqual", "2"),

    @JsonProperty("added")
    ADDED("added", "3"),

    @JsonProperty("removed")
    REMOVED("removed", "4");

    private final String name;
    private final String value;

    private DeviceManagementComparisonResult(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
