package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum DeviceManagementCertificationAuthority implements Enum {

    @JsonProperty("notConfigured")
    NOT_CONFIGURED("notConfigured", "0"),

    @JsonProperty("microsoft")
    MICROSOFT("microsoft", "1"),

    @JsonProperty("digiCert")
    DIGI_CERT("digiCert", "2");

    private final String name;
    private final String value;

    private DeviceManagementCertificationAuthority(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
