package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum DeviceManagementAutopilotPolicyType implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("application")
    APPLICATION("application", "3"),

    @JsonProperty("appModel")
    APP_MODEL("appModel", "7"),

    @JsonProperty("configurationPolicy")
    CONFIGURATION_POLICY("configurationPolicy", "12");

    private final String name;
    private final String value;

    private DeviceManagementAutopilotPolicyType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
