package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum DeviceManagementApplicabilityRuleType implements Enum {

    @JsonProperty("include")
    INCLUDE("include", "0"),

    @JsonProperty("exclude")
    EXCLUDE("exclude", "1");

    private final String name;
    private final String value;

    private DeviceManagementApplicabilityRuleType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
