package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum DeviceEnrollmentFailureReason implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("authentication")
    AUTHENTICATION("authentication", "1"),

    @JsonProperty("authorization")
    AUTHORIZATION("authorization", "2"),

    @JsonProperty("accountValidation")
    ACCOUNT_VALIDATION("accountValidation", "3"),

    @JsonProperty("userValidation")
    USER_VALIDATION("userValidation", "4"),

    @JsonProperty("deviceNotSupported")
    DEVICE_NOT_SUPPORTED("deviceNotSupported", "5"),

    @JsonProperty("inMaintenance")
    IN_MAINTENANCE("inMaintenance", "6"),

    @JsonProperty("badRequest")
    BAD_REQUEST("badRequest", "7"),

    @JsonProperty("featureNotSupported")
    FEATURE_NOT_SUPPORTED("featureNotSupported", "8"),

    @JsonProperty("enrollmentRestrictionsEnforced")
    ENROLLMENT_RESTRICTIONS_ENFORCED("enrollmentRestrictionsEnforced", "9"),

    @JsonProperty("clientDisconnected")
    CLIENT_DISCONNECTED("clientDisconnected", "10"),

    @JsonProperty("userAbandonment")
    USER_ABANDONMENT("userAbandonment", "11");

    private final String name;
    private final String value;

    private DeviceEnrollmentFailureReason(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
