package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum DeviceAppManagementTaskStatus implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("pending")
    PENDING("pending", "1"),

    @JsonProperty("active")
    ACTIVE("active", "2"),

    @JsonProperty("completed")
    COMPLETED("completed", "3"),

    @JsonProperty("rejected")
    REJECTED("rejected", "4");

    private final String name;
    private final String value;

    private DeviceAppManagementTaskStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
