package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum DerivedCredentialProviderType implements Enum {

    @JsonProperty("notConfigured")
    NOT_CONFIGURED("notConfigured", "0"),

    @JsonProperty("entrustDataCard")
    ENTRUST_DATA_CARD("entrustDataCard", "1"),

    @JsonProperty("purebred")
    PUREBRED("purebred", "2"),

    @JsonProperty("xTec")
    X_TEC("xTec", "3"),

    @JsonProperty("intercede")
    INTERCEDE("intercede", "4");

    private final String name;
    private final String value;

    private DerivedCredentialProviderType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
