package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum DeliveryOptimizationGroupIdOptionsType implements Enum {

    @JsonProperty("notConfigured")
    NOT_CONFIGURED("notConfigured", "0"),

    @JsonProperty("adSite")
    AD_SITE("adSite", "1"),

    @JsonProperty("authenticatedDomainSid")
    AUTHENTICATED_DOMAIN_SID("authenticatedDomainSid", "2"),

    @JsonProperty("dhcpUserOption")
    DHCP_USER_OPTION("dhcpUserOption", "3"),

    @JsonProperty("dnsSuffix")
    DNS_SUFFIX("dnsSuffix", "4");

    private final String name;
    private final String value;

    private DeliveryOptimizationGroupIdOptionsType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
