package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum DefenderSubmitSamplesConsentType implements Enum {

    @JsonProperty("sendSafeSamplesAutomatically")
    SEND_SAFE_SAMPLES_AUTOMATICALLY("sendSafeSamplesAutomatically", "0"),

    @JsonProperty("alwaysPrompt")
    ALWAYS_PROMPT("alwaysPrompt", "1"),

    @JsonProperty("neverSend")
    NEVER_SEND("neverSend", "2"),

    @JsonProperty("sendAllSamplesAutomatically")
    SEND_ALL_SAMPLES_AUTOMATICALLY("sendAllSamplesAutomatically", "3");

    private final String name;
    private final String value;

    private DefenderSubmitSamplesConsentType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
