package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum DefenderScanType implements Enum {

    @JsonProperty("userDefined")
    USER_DEFINED("userDefined", "0"),

    @JsonProperty("disabled")
    DISABLED("disabled", "1"),

    @JsonProperty("quick")
    QUICK("quick", "2"),

    @JsonProperty("full")
    FULL("full", "3");

    private final String name;
    private final String value;

    private DefenderScanType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
