package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum DefenderRealtimeScanDirection implements Enum {

    @JsonProperty("monitorAllFiles")
    MONITOR_ALL_FILES("monitorAllFiles", "0"),

    @JsonProperty("monitorIncomingFilesOnly")
    MONITOR_INCOMING_FILES_ONLY("monitorIncomingFilesOnly", "1"),

    @JsonProperty("monitorOutgoingFilesOnly")
    MONITOR_OUTGOING_FILES_ONLY("monitorOutgoingFilesOnly", "2");

    private final String name;
    private final String value;

    private DefenderRealtimeScanDirection(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
