package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum DefenderMonitorFileActivity implements Enum {

    @JsonProperty("userDefined")
    USER_DEFINED("userDefined", "0"),

    @JsonProperty("disable")
    DISABLE("disable", "1"),

    @JsonProperty("monitorAllFiles")
    MONITOR_ALL_FILES("monitorAllFiles", "2"),

    @JsonProperty("monitorIncomingFilesOnly")
    MONITOR_INCOMING_FILES_ONLY("monitorIncomingFilesOnly", "3"),

    @JsonProperty("monitorOutgoingFilesOnly")
    MONITOR_OUTGOING_FILES_ONLY("monitorOutgoingFilesOnly", "4");

    private final String name;
    private final String value;

    private DefenderMonitorFileActivity(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
