package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum DataPolicyOperationStatus implements Enum {

    @JsonProperty("notStarted")
    NOT_STARTED("notStarted", "0"),

    @JsonProperty("running")
    RUNNING("running", "1"),

    @JsonProperty("complete")
    COMPLETE("complete", "2"),

    @JsonProperty("failed")
    FAILED("failed", "3"),

    @JsonProperty("unknownFutureValue")
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "4");

    private final String name;
    private final String value;

    private DataPolicyOperationStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
