package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum ConversationIdentityType implements Enum {

    @JsonProperty("team")
    TEAM("team", "0"),

    @JsonProperty("channel")
    CHANNEL("channel", "1");

    private final String name;
    private final String value;

    private ConversationIdentityType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
