package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum ContactRelationship implements Enum {

    @JsonProperty("parent")
    PARENT("parent", "0"),

    @JsonProperty("relative")
    RELATIVE("relative", "1"),

    @JsonProperty("aide")
    AIDE("aide", "2"),

    @JsonProperty("doctor")
    DOCTOR("doctor", "3"),

    @JsonProperty("guardian")
    GUARDIAN("guardian", "4"),

    @JsonProperty("child")
    CHILD("child", "5"),

    @JsonProperty("other")
    OTHER("other", "6"),

    @JsonProperty("unknownFutureValue")
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "7");

    private final String name;
    private final String value;

    private ContactRelationship(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
