package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum ConnectorGroupRegion implements Enum {

    @JsonProperty("nam")
    NAM("nam", "0"),

    @JsonProperty("eur")
    EUR("eur", "1"),

    @JsonProperty("aus")
    AUS("aus", "2"),

    @JsonProperty("asia")
    ASIA("asia", "3"),

    @JsonProperty("ind")
    IND("ind", "4"),

    @JsonProperty("unknownFutureValue")
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "5");

    private final String name;
    private final String value;

    private ConnectorGroupRegion(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
