package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum ConnectionStatus implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("attempted")
    ATTEMPTED("attempted", "1"),

    @JsonProperty("succeeded")
    SUCCEEDED("succeeded", "2"),

    @JsonProperty("blocked")
    BLOCKED("blocked", "3"),

    @JsonProperty("failed")
    FAILED("failed", "4"),

    @JsonProperty("unknownFutureValue")
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "127");

    private final String name;
    private final String value;

    private ConnectionStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
