package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum ConfigurationManagerActionType implements Enum {

    @JsonProperty("refreshMachinePolicy")
    REFRESH_MACHINE_POLICY("refreshMachinePolicy", "0"),

    @JsonProperty("refreshUserPolicy")
    REFRESH_USER_POLICY("refreshUserPolicy", "1"),

    @JsonProperty("wakeUpClient")
    WAKE_UP_CLIENT("wakeUpClient", "2"),

    @JsonProperty("appEvaluation")
    APP_EVALUATION("appEvaluation", "3");

    private final String name;
    private final String value;

    private ConfigurationManagerActionType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
