package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum ConditionalAccessStatus implements Enum {

    @JsonProperty("success")
    SUCCESS("success", "0"),

    @JsonProperty("failure")
    FAILURE("failure", "1"),

    @JsonProperty("notApplied")
    NOT_APPLIED("notApplied", "2"),

    @JsonProperty("unknownFutureValue")
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "3");

    private final String name;
    private final String value;

    private ConditionalAccessStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
