package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum ConditionalAccessGrantControl implements Enum {

    @JsonProperty("block")
    BLOCK("block", "0"),

    @JsonProperty("mfa")
    MFA("mfa", "1"),

    @JsonProperty("compliantDevice")
    COMPLIANT_DEVICE("compliantDevice", "2"),

    @JsonProperty("domainJoinedDevice")
    DOMAIN_JOINED_DEVICE("domainJoinedDevice", "3"),

    @JsonProperty("approvedApplication")
    APPROVED_APPLICATION("approvedApplication", "4"),

    @JsonProperty("compliantApplication")
    COMPLIANT_APPLICATION("compliantApplication", "5"),

    @JsonProperty("passwordChange")
    PASSWORD_CHANGE("passwordChange", "6"),

    @JsonProperty("unknownFutureValue")
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "7");

    private final String name;
    private final String value;

    private ConditionalAccessGrantControl(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
