package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum ConditionalAccessDevicePlatform implements Enum {

    @JsonProperty("android")
    ANDROID("android", "0"),

    @JsonProperty("iOS")
    I_OS("iOS", "1"),

    @JsonProperty("windows")
    WINDOWS("windows", "2"),

    @JsonProperty("windowsPhone")
    WINDOWS_PHONE("windowsPhone", "3"),

    @JsonProperty("macOS")
    MAC_OS("macOS", "4"),

    @JsonProperty("all")
    ALL("all", "5"),

    @JsonProperty("unknownFutureValue")
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "6");

    private final String name;
    private final String value;

    private ConditionalAccessDevicePlatform(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
