package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum ConditionalAccessClientApp implements Enum {

    @JsonProperty("all")
    ALL("all", "0"),

    @JsonProperty("browser")
    BROWSER("browser", "1"),

    @JsonProperty("mobileAppsAndDesktopClients")
    MOBILE_APPS_AND_DESKTOP_CLIENTS("mobileAppsAndDesktopClients", "2"),

    @JsonProperty("exchangeActiveSync")
    EXCHANGE_ACTIVE_SYNC("exchangeActiveSync", "3"),

    @JsonProperty("easSupported")
    EAS_SUPPORTED("easSupported", "4"),

    @JsonProperty("other")
    OTHER("other", "5"),

    @JsonProperty("unknownFutureValue")
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "6");

    private final String name;
    private final String value;

    private ConditionalAccessClientApp(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
